---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：27-Explain API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **REST APIエンドポイントパス**：RestExplainActionのコード未精査

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/explain/TransportExplainAction.java` - 実行ロジック
- E-02: `server/src/main/java/org/opensearch/action/explain/ExplainRequest.java` - リクエスト構造
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportSingleShardAction継承 | E-01 (77行目) | ○ |
| C-02 | GETスレッドプールで実行 | E-01 (98行目) | ○ |
| C-03 | クエリリライト実行 | E-01 (111-115行目) | ○ |
| C-04 | エイリアスフィルタ構築 | E-01 (126行目) | ○ |
| C-05 | ルーティング必須チェック | E-01 (129-131行目) | ○ |
| C-06 | searchService.createSearchContext | E-01 (151行目) | ○ |
| C-07 | Engine.Getでドキュメント取得 | E-01 (156行目) | ○ |
| C-08 | ドキュメント不存在時はmatched=false | E-01 (157-158行目) | ○ |
| C-09 | searcher.explain()でExplanation取得 | E-01 (163行目) | ○ |
| C-10 | rescorer.explain()でリスコア説明追加 | E-01 (164-167行目) | ○ |
| C-11 | _source/ストアドフィールド取得 | E-01 (168-175行目) | ○ |
| C-12 | AggregatedDfs未対応（TODO） | E-01 (76行目) | ○ |
| C-13 | awaitShardSearchActive | E-01 (139行目) | ○ |
| C-14 | SEARCH_THROTTLEDスレッドプール対応 | E-01 (204-209行目) | ○ |
| C-15 | idとqueryが必須 | E-02 (176-184行目) | ○ |
| C-16 | REST APIエンドポイントパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- REST APIエンドポイント：RestExplainActionの詳細コードを参照していない
  - 候補：RestExplainAction.java

## 5) リスクフラグ（レビュー観点）
- 0: REST APIパスの正確性

## 6) レビュアーチェックリスト（最小）
- [ ] REST APIエンドポイントパスの正確性を確認
- [ ] AggregatedDfs未対応の影響範囲を確認
